% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2d_volume.R
\name{plot_2d_volume}
\alias{plot_2d_volume}
\title{Plot Volume Changes by Segment Over Time}
\usage{
plot_2d_volume(
  volume_data,
  segment_names = "Segment",
  title = "Volume Change by Segment"
)
}
\arguments{
\item{volume_data}{A data frame with volume measurements, one column per segment, and a "frame" column for time.}

\item{segment_names}{Column that contain name of segment to plot}

\item{title}{Optional plot title.}
}
\value{
A ggplot object showing volume changes by segment over time.
}
\description{
This function generates a ggplot to display the volume changes by segment over time.
It creates a line plot with each segment's volume on the y-axis and the timeframe on the x-axis.
}
\examples{
# Example usage with random volume data
set.seed(123)
volume_data <- data.frame(
  Timeframe = 1:100,
  Volume = runif(100, min = 100, max = 150),
  Segment = 'UL'
)

plot_2d_volume(volume_data, segment_names = 'Segment')

}
