% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jones_model.R
\name{jones_model}
\alias{jones_model}
\title{Jones Model}
\usage{
jones_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill for each temperature (TRUE is default).}
}
\value{
The function returns values the chill for each temperature of vector (Total = FALSE), or returns the chill accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by means of converting temperatures to exponential units temperature.
}
\examples{
 
 x <- rnorm(500, 8, 5)
jones_model(x)
jones_model(x, FALSE) 
 
}
\references{
JONES, H. G., HILLIS, R. M., GORDON, S. L., and BRENNAN, R. M. (2013). An approach to the determination of winter chill requirements for different Ribes cultivars. Plant. Biol.
}
