% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q10_bidabe.R
\name{q10_bidabe}
\alias{q10_bidabe}
\title{Bidabe Model}
\usage{
q10_bidabe(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values for each temperature of vector (Total = FALSE), or returns the accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by means of converting temperatures to temperature coeficients (Q10).
}
\details{
The model is based on temperature coeficients (Q10). The Q10 coeficient is variable for each specie. The model contains dinamic variables. This model is been aplied in the warm climates. Was based on an exponential function that decreases according to the increase in temperature.
}
\examples{

x <- rnorm(500, 10, 3)
q10_bidabe(x)
q10_bidabe(x, FALSE)

}
\references{
BIDABE, B. 1967. Action de la temperature sur l' evolution des bourgeons de pommier et comparaison de methodes de controle de l' epoque de floraison. Annu. Physiol. Veg.
}
