/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UnionFind<T> {
    private Map<T, T> parentMap = new HashMap<T, T>();
    private Map<T, Integer> rankMap = new HashMap<T, Integer>();

    public UnionFind(Set<T> set) {
        for (T t : set) {
            this.parentMap.put(t, t);
            this.rankMap.put(t, 0);
        }
    }

    public void addElement(T t) {
        this.parentMap.put(t, t);
        this.rankMap.put(t, 0);
    }

    protected Map<T, T> getParentMap() {
        return this.parentMap;
    }

    protected Map<T, Integer> getRankMap() {
        return this.rankMap;
    }

    public T find(T t) {
        if (!this.parentMap.containsKey(t)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T t2 = this.parentMap.get(t);
        if (t2.equals(t)) {
            return t;
        }
        T t3 = this.find(t2);
        this.parentMap.put(t, t3);
        return t3;
    }

    public void union(T t, T t2) {
        int n;
        T t3;
        if (!this.parentMap.containsKey(t) || !this.parentMap.containsKey(t2)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T t4 = this.find(t);
        if (t4.equals(t3 = this.find(t2))) {
            return;
        }
        int n2 = this.rankMap.get(t4);
        if (n2 > (n = this.rankMap.get(t3).intValue())) {
            this.parentMap.put(t3, t4);
        } else if (n2 < n) {
            this.parentMap.put(t4, t3);
        } else {
            this.parentMap.put(t3, t4);
            this.rankMap.put(t4, n2 + 1);
        }
    }
}

