% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{lmvgamma}
\alias{lmvgamma}
\alias{mvgamma}
\title{Multivariate Gamma Function}
\usage{
lmvgamma(x, p)

mvgamma(x, p)
}
\arguments{
\item{x}{non-negative numeric vector, matrix, or array}

\item{p}{positive integer, dimension of a square matrix}
}
\value{
For \code{lmvgamma} log of multivariate gamma of dimension \code{p} for each entry of \code{x}. For non-log variant,
    use \code{mvgamma}.
}
\description{
A special mathematical function related to the gamma function,
    generalized for multivariate gammas.
}
\section{Functions}{
\itemize{
\item \code{mvgamma}: Multivariate gamma function.
}}

\examples{
lgamma(1:12)
lmvgamma(1:12,1)
mvgamma(1:12,1)
gamma(1:12)
}
\seealso{
\code{\link{gamma}} and \code{\link{lgamma}}
}
