% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhyloCharCompletenessInBins.r
\name{PhyloCharCompletenessInBins}
\alias{PhyloCharCompletenessInBins}
\title{Phylogenetic character completeness in time-bins}
\usage{
PhyloCharCompletenessInBins(CladisticMatrix, TimeTree, TimeBins,
  plot = FALSE, CI = 0.95)
}
\arguments{
\item{CladisticMatrix}{A cladistic matrix in the form imported by \link{ReadMorphNexus}.}

\item{TimeTree}{A time-scaled phylogenetic tree containing all the taxa in \code{CladisticMatrix}.}

\item{TimeBins}{A set of time bin boundaries (oldest to youngest) in millions of years.}

\item{plot}{An optional choice to plot the results (default is \code{FALSE}).}

\item{CI}{The confidence interval to be used as a proportion (0 to 1). Default is 0.95 (i.e., 95\%).}
}
\value{
A list summarising the mean, upper and lower 95% confidence interval, and per character proportional character completeness in each time bin.
}
\description{
Given a cladistic matrix, time-scaled tree, and set of time bin boundaries will return the proportional character completeness in each bin.
}
\details{
Character completeness metrics have been used as an additional metric for comparing fossil record quality across time, space, and taxa. However, these only usually refer to point samples of fossils in bins, and not our ability to infer information along the branches of a phylogenetic tree.

This function returns the proportional phylogenetic character completeness for a set of time bins.
}
\examples{

# Create a random tree for the Day et al. 2016 data set:
Day2016tree <- rtree(nrow(Day2016$Matrix_1$Matrix))
Day2016tree$tip.label <- rownames(Day2016$Matrix_1$Matrix)
Day2016tree$root.time <- max(diag(vcv(Day2016tree)))

# Get proportional phylogenetic character completeness in ten equal-length
# time bins:
PhyloCharCompletenessInBins(CladisticMatrix = Day2016,
  TimeTree = Day2016tree, TimeBins = seq(from =
  Day2016tree$root.time, to = Day2016tree$root.time -
  max(diag(vcv(Day2016tree))), length.out = 11))

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
