% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClimDown.R
\name{parallelization}
\alias{parallelization}
\title{Parallelization}
\description{
\pkg{ClimDown} uses the \pkg{foreach} package to
support parallelization where possible. In general, most of
\pkg{ClimDown}'s computations contain an outer I/O chunk loop and
an inner computational loop. The outer chunk loop serially reads in
as much data from input files as it feasibly can, and then the
inner loop will execute in parallel if the user has configured a
parallel engine.

Users can configure a parallel engine before execution using either
the \pkg{doParallel} or \pkg{doMPI} packages.

If the user does not configure a parallel backend, the inner loops
will simply run serially and issue a warning.
}
\examples{
\dontrun{
library(doParallel)
registerDoParallel(cores=4)
bccaq.netcdf.wrapper(...)
stopImplicitCluster()}

}
\seealso{
\pkg{doParallel} and \pkg{doMPI}
}

