% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwi1D.R
\name{fwi1D}
\alias{fwi1D}
\title{Fire Weather Index applied to 1D data}
\usage{
fwi1D(dates, Tm, H, r, W, lat = 46, what = "FWI", init.pars = c(85,
  6, 15), spin.up = 0)
}
\arguments{
\item{dates}{Vector of dates. This is a character string in the form \code{d/m/y}}

\item{Tm}{Vector of temperature records (deg. Celsius)}

\item{H}{Vector of relative humidity records (\%)}

\item{r}{Vector of last 24-h accumulated precipitation (mm)}

\item{W}{Vector of wind velocity records (Km/h)}

\item{lat}{Optional. Latitude of the records (in decimal degrees). Default to 46,
applying the default parameters of the original FWI System, developed in Canada. See Daylength Adjustment details.}

\item{what}{Character vector, indicating the components of the FWI system to be returned.
Accepted values include any possible subset of the set \{\code{"FFMC"},\code{"DMC"},\code{"DC"}
,\code{"BUI"},\code{"ISI"},\code{"FWI"},\code{"DSR"}\}. Default to \code{"FWI"}.}

\item{init.pars}{A numeric vector of length 3 with the initialization values for the
FFMC, DMC and DC components, in this order. Default values as proposed by van Wagner (1987).}

\item{spin.up}{Non-negative integer indicating the number of days considered for FWI spin-up.
Default to 0 (i.e. no spin-up is considered). See the dedicated Section below for further details.}
}
\value{
A matrix with the time (days) arranged in rows and the components selected in \code{what}
in columns. The attribute \code{colnames} gives the component ordering. Default to a single-colum matrix returning FWI.
}
\description{
Implementation of the Canadian Fire Weather Index System for vector data
}
\note{
The FWI system should be computed by definition upon instantaneous values of temperature, relative humidity and wind speed measured a "noon local standar time", plus
24-h accumulated precipitation. The use of inadequate temporal resolution has important implicationas, as highlighted by Herrera \emph{et al.} (2013).
However, prior studies rely on adequate proxies, in order to exploit model databases containing just daily data (see e.g. Bediat \emph{et al.} (2014)).
}
\section{Daylength adjustment factors}{
 
By default, the function applies the original FWI daylength adjustment factors for DC and DMC (van Wagner 1987),
 although it is possible to adjust them by as a function of latitude through the argument \code{lat}.
The reference values used for each latitudinal range are those indicated in p.71 and Tables A3.1 and A3.2 (p69) in
Lawson and Armitage (2008).
}

\section{FWI spin-up}{

FWI is initialized with some values for FFMC, DMC and DC components. This means that the first values of the series are not reliable,
 until the index is iterated over several time steps and stabilizes (typically a few days suffice).
 Thus, the first index values can be optionally set to \code{NA}. The number of days at the beginning of the series to be set to \code{NA}
  is controlled via the \code{spin.up} argument.
}

\references{
\itemize{
\item Lawson, B.D. & Armitage, O.B., 2008. Weather guide for the Canadian Forest Fire Danger Rating System. Northern Forestry Centre, Edmonton (Canada).

\item van Wagner, C.E., 1987. Development and structure of the Canadian Forest Fire Weather Index (Forestry Tech. Rep. No. 35). Canadian Forestry Service, Ottawa, Canada.

\item van Wagner, C.E., Pickett, T.L., 1985. Equations and FORTRAN program for the Canadian forest fire weather index system (Forestry Tech. Rep. No. 33). Canadian Forestry Service, Ottawa, Canada.

\item Herrera, S., Bedia, J., Gutierrez, J.M., Fernandez, J., Moreno, J.M., 2013. On the projection of future fire danger conditions with various instantaneous/mean-daily data sources. Climatic Change 118, 827-840. 

\item Bedia, J., Herrera, S., Camia, A., Moreno, J.M., Gutierrez, J.M., 2014. Forest Fire Danger Projections in the Mediterranean using ENSEMBLES Regional Climate Change Scenarios. Climatic Change 122, 185-199. 
}
}
\author{
Joaquin Bedia-Jiménez
}
\keyword{internal}
