% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArrayToList.R
\name{ArrayToList}
\alias{ArrayToList}
\title{Split an array into list by a given array dimension}
\usage{
ArrayToList(data, dim, level = "list", names = NULL)
}
\arguments{
\item{data}{A multidimensional array.}

\item{dim}{A character string indicating the name of the dimension to split or an integer indicating the position of the dimension.}

\item{level}{A string character 'list' or 'sublist' indicating if it should be a list or a sublist. By default it creates a list.}

\item{names}{A vector of character strings to name the list (if it is a single string, it would be reused) or a single character string to name the elements in the sublist.}
}
\value{
A list of arrays of the length of the dimension set in parameter 'dim'.
}
\description{
This function splits an array into a list as required by PlotLayout function from package "s2dv" when parameter 'special_args' is used. The function ArrayToList allows to add names to the elements of the list in two different levels, the 'list' or the 'sublist'.
}
\examples{
data <- array(1:240, c(month = 12, member = 5, time = 4))
# Create a list:
datalist <- ArrayToList(data, dim = 'month', level = 'list', names = month.name)
class(datalist)
class(datalist[[1]])
str(datalist)
# Create a sublist:
datalist <- ArrayToList(data, dim = 'month', level = 'sublist', names = 'dots')
class(datalist)
class(datalist[[1]])
class(datalist[[1]][[1]])
str(datalist)
}
\seealso{
\link[s2dv]{PlotLayout}
}

