% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{create_seurat_object_default}
\alias{create_seurat_object_default}
\title{Create Seurat object}
\usage{
create_seurat_object_default(
  normalized_expression_matrix,
  count_matrix = NULL,
  pca_embedding = NULL,
  umap_embedding = NULL,
  metadata_df = NULL
)
}
\arguments{
\item{normalized_expression_matrix}{The normalized expression matrix
having genes on rows and cells on columns.}

\item{count_matrix}{The count matrix having genes on rows and cells on
columns. If NULL, the normalized_expression_matrix will be used.}

\item{pca_embedding}{The PCA embedding of the expression matrix. If NULL, the
pca will be created using the \code{Seurat} package (default parameters).}

\item{umap_embedding}{The UMAP embedding of the expression matrix. If NULL, the
umap will be created using the \code{Seurat} package (default parameters).}

\item{metadata_df}{The metadata dataframe having the cell names as rownames.
If NULL, a dataframe with a single column named \code{identical_ident} will be
created.}
}
\value{
A Seurat object of the expression matrix, having the stable number
of clusters identified by ClustAssess.
}
\description{
Use a normalized expression matrix and, potentially, an already
generated PCA / UMAP embedding, to create a Seurat object.
}
