#' @export print.clustvar
#' @export
#' @name print.clustvar
#' @title Print an  object of class \code{clustvar}
#' @description This is a method for the function print for objects of the class
#' \code{clustvar}.
#' @param x An object of class \code{clustvar} generated by the functions
#' \code{\link{cutreevar}} and \code{\link{kmeansvar}}.
#' @param \dots Further arguments to be passed to or from other methods. They are ignored in this function.
#' @keywords internal
#' 
print.clustvar <- function(x, ...){
  if (!inherits(x, "clustvar")) 
    stop("use only with \"clustvar\" objects")
  cat("\nCall:\n", deparse(x$call), "\n\n", sep = "")
  iter <- x$iter
  if (is.numeric(iter)) cat("number of iterations: ",iter,sep=" ") 
  cat("\n")
  cat("\n")
  res <- matrix("",8,2)
  colnames(res) <-c("name","description")
  res[1,] <- c("$var", "list of variables in each cluster")
  res[2,] <- c("$sim", "similarity matrix in each cluster")
  res[3,] <- c("$cluster", "cluster memberships")
  res[4,] <- c("$wss", "within-cluster sum of squares")
  res[5,] <- c("$E", "gain in cohesion (in %)")
  res[6,] <- c("$size", "size of each cluster")
  res[7,] <- c("$scores", "synthetic score of each cluster")
  res[8,] <- c("$coef", "coef of the linear combinations defining the synthetic scores of each cluster")
  row.names(res) <- rep("",8)
  
  print(res)
}

