% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopyCohorts.R
\name{copyCohorts}
\alias{copyCohorts}
\title{Copy cohorts from one table to another}
\usage{
copyCohorts(
  connectionDetails = NULL,
  connection = NULL,
  oldToNewCohortId,
  sourceCohortDatabaseSchema = NULL,
  targetCohortDatabaseSchema = sourceCohortDatabaseSchema,
  sourceCohortTable,
  targetCohortTable,
  isTempTable = FALSE,
  purgeConflicts = FALSE,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{oldToNewCohortId}{A data.frame object with two columns. oldCohortId and newCohortId. Both should be integers.
The oldCohortId are the cohorts that are the input cohorts that need to be transformed.
The newCohortId are the cohortIds of the corresponding output after transformation.
If the oldCohortId = newCohortId then the data corresponding to oldCohortId
will be replaced by the data from the newCohortId.}

\item{sourceCohortDatabaseSchema}{The database schema of the source cohort table.}

\item{targetCohortDatabaseSchema}{The database schema of the source cohort table.}

\item{sourceCohortTable}{The name of the source cohort table.}

\item{targetCohortTable}{The name of the target cohort table.}

\item{isTempTable}{Is the output a temp table. If yes, a new temp table is created. This will required
an active connection. Any old temp table is dropped and replaced.}

\item{purgeConflicts}{If there are conflicts in the target cohort table i.e. the target cohort table
already has records with newCohortId, do you want to purge and replace them
with transformed. By default - it will not be replaced, and an error message is thrown.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
Nothing is returned
}
\description{
Copy cohorts from one table to another table. If the new cohort table
has any cohort id that matches the cohort id being copied, an error will
be displayed.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
