% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDemographics.R
\name{requireDemographics}
\alias{requireDemographics}
\title{Restrict cohort on patient demographics}
\usage{
requireDemographics(
  cohort,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  ageRange = list(c(0, 150)),
  sex = c("Both"),
  minPriorObservation = 0,
  minFutureObservation = 0,
  requirementInteractions = TRUE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in cohort that contains the date to compute the
demographics characteristics on which to restrict on.}

\item{ageRange}{A list of minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female". If one of the latter, only
those with that sex will be included.}

\item{minPriorObservation}{A minimum number of prior observation days in
the database.}

\item{minFutureObservation}{A minimum number of future observation days in
the database.}

\item{requirementInteractions}{If TRUE, cohorts will be created for
all combinations of ageGroup, sex, and daysPriorObservation. If FALSE, only the
first value specified for the other factors will be used. Consequently,
order of values matters when requirementInteractions is FALSE.}

\item{name}{Name of the new cohort with the demographic requirements.}
}
\value{
The cohort table with only records for individuals satisfying the
demographic requirements
}
\description{
Restrict cohort on patient demographics
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(nPerson = 100)
cdm$cohort1 |>
  requireDemographics(indexDate = "cohort_start_date",
                      ageRange = list(c(18, 65)),
                      sex = "Female",
                      minPriorObservation = 365)
}
}
