% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDateRange.R
\name{requireInDateRange}
\alias{requireInDateRange}
\title{Require that an index date is within a date range}
\usage{
requireInDateRange(
  cohort,
  dateRange,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{dateRange}{A window of time during which the index date must have
been observed.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in cohort that contains the index date of interest}

\item{name}{Name of the new cohort with the restriction.}
}
\value{
The cohort table with any cohort entries outside of the date range
dropped
}
\description{
Require that an index date is within a date range
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)
cdm$cohort1 |>
  requireInDateRange(indexDate = "cohort_start_date",
                     dateRange = as.Date(c("2010-01-01", "2019-01-01")))
}
}
