% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortTables.R
\name{getCohortTableNames}
\alias{getCohortTableNames}
\title{Used to get a list of cohort table names to use when creating the cohort
tables}
\usage{
getCohortTableNames(
  cohortTable = "cohort",
  cohortSampleTable = cohortTable,
  cohortInclusionTable = paste0(cohortTable, "_inclusion"),
  cohortInclusionResultTable = paste0(cohortTable, "_inclusion_result"),
  cohortInclusionStatsTable = paste0(cohortTable, "_inclusion_stats"),
  cohortSummaryStatsTable = paste0(cohortTable, "_summary_stats"),
  cohortCensorStatsTable = paste0(cohortTable, "_censor_stats")
)
}
\arguments{
\item{cohortTable}{Name of the cohort table.}

\item{cohortSampleTable}{Name of the cohort table for sampled cohorts (defaults to the same as the cohort table).}

\item{cohortInclusionTable}{Name of the inclusion table, one of the tables for storing
inclusion rule statistics.}

\item{cohortInclusionResultTable}{Name of the inclusion result table, one of the tables for
storing inclusion rule statistics.}

\item{cohortInclusionStatsTable}{Name of the inclusion stats table, one of the tables for storing
inclusion rule statistics.}

\item{cohortSummaryStatsTable}{Name of the summary stats table, one of the tables for storing
inclusion rule statistics.}

\item{cohortCensorStatsTable}{Name of the censor stats table, one of the tables for storing
inclusion rule statistics.}
}
\value{
A list of the table names as specified in the parameters to this function.
}
\description{
This function creates a list of table names used by \code{\link{createCohortTables}} to specify
the table names to create. Use this function to specify the names of the main cohort table
and cohort statistics tables.
}
