% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_rbedInfo.R
\name{runGcdh}
\alias{runGcdh}
\title{Run GCDH analysis}
\usage{
runGcdh(pl_gwas, n_shift, gwas_col_select = NULL, collapse_matrix = NULL,
  rm_shifted_files = TRUE, dist_threshold = 5e+05)
}
\arguments{
\item{pl_gwas}{PlGwasC object}

\item{n_shift}{integer. Maximum shift number.}

\item{gwas_col_select}{character. Columns to read from a GWAS output file. Default to \code{collenv$.linear_header_default}}

\item{collapse_matrix}{matrix. 4 by 4 matrix used for generating collapsed genotypes.}

\item{rm_shifted_files}{logical. Whether to remove shifted bed files after analysis is done.}

\item{dist_threshold}{integer. SNPs beyond this distance will be ignored. Default to 500kb.}
}
\value{
A list with the following members: (1) the input PlGwasC object. (2) an info data frame with CHR, BP and SNP columns. (3) One big.matrix object for each of the names in \code{gwas_col_select}
}
\description{
Runs GCDH over the given PlGwasC object.
The PlGwasC object is first filtered by p-values from a \code{plink --assoc} run if a p-value threshold is given.
New PlGwasC objects are generated by shifting the PLINK bed file (e.g. shift1.bed, shift2.bed, ...) one by one.
A GWAS is run for each of these PlGwasC objects and results are collected into big.matrix files.
}
\author{
Kaiyin Zhong, Fan Liu
}

