% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_lin_semiparm.R
\name{score_cont_semiparam}
\alias{score_cont_semiparam}
\title{Semiparametric score function for distance-based kernel and continuous outcome.}
\usage{
score_cont_semiparam(outcome, covars, dist_mat, grid_gran = 5000)
}
\arguments{
\item{outcome}{a numeric vector containing the continuous outcome variable (in the same ID order as dist_mat)}

\item{covars}{a data frame containing the covariates to be modeled parametrically (should NOT include an ID variable)}

\item{dist_mat}{a square distance matrix}

\item{grid_gran}{a numeric value specifying the grid search length, preset to 5000}
}
\value{
the score function p-value for the kernel score test of association.
}
\description{
Description of the semiparametric score function for distance-based kernel function and continuous outcome.
}
\details{
This is the main function that calculates the p-value associated with a semiparametric kernel test
of association between the kernel and continuous outcome variable. A null model (where the kernel is not
associated with the outcome) is initially fit. Then, the variance of
\eqn{Y_{i}|X_{i}}{Y_i | X_i} is used as the basis for the
score test,
\deqn{S\left(\rho\right) = \frac{Q_{\tau}\left(\hat{\beta_0},\rho\right)-\mu_Q}{\sigma_Q}.}{S(rho) = (Q_tau(beta_0, rho)-mu_Q) / (sigma_Q).}
However,
because \eqn{\rho}{rho} disappears under the null hypothesis, we run a grid search over a range of values of \eqn{\rho}{rho} (the bounds
of which were derived by Liu et al. in 2008). This grid search gets the upper bound for the score test's p-value.
This function is tailored for the underlying model
\deqn{y_{i} = x_{i}^{T}\beta + h\left(z_{i}\right) + e_{i},}{y_i = x_i^T beta + h(z_i) + e_i,}
where \eqn{h\left(\cdot\right)}{h(.)} is
the kernel function, \eqn{z_{i}}{z_i} is a multidimensional array of variables, \eqn{x_{i}}{x_i} is a vector or matrix of covariates, \eqn{\beta}{beta} is a vector
of regression coefficients, and \eqn{y_{i}}{y_i} is a continuous outcome taking values in the real numbers.
}
\examples{
data(simasd_hamil_df)
data(simasd_covars)

hamil_matrix <- ham_distance(simasd_hamil_df)
covars_df <- simasd_covars[,3:4]

\donttest{
score_cont_semiparam(
  outcome   = simasd_covars$verbal_IQ,
  covars    = covars_df,
  dist_mat  = hamil_matrix,
  grid_gran = 5000
  )
}

}
\references{
Liu D, Ghosh D, and Lin X (2008) "Estimation and testing for the effect of a
genetic pathway on a disease outcome using logistic kernel machine regression via
logistic mixed models." BMC Bioinformatics, 9(1), 292. ISSN 1471-2105.
\doi{10.1186/1471-2105-9-292}.
}
\seealso{
\code{\link{hms}}, \code{\link{ext_distance}}, \code{\link{ham_distance}}
\code{\link{score_log_semiparam}} for semiparametric score function of distance-based kernel functions and binary outcome.
\code{\link{score_log_nonparam}} for nonparametric score function of distance-based kernel functions and binary outcome.
\code{\link{score_cont_nonparam}} for nonparametric score function of distance-based kernel function and continuous outcome.
}
