/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;

public class DeveloperUtil {
    private static String INDENT_STRING = "    ";

    public static String getWindowLayoutAsString(DockingWindow dockingWindow) {
        return DeveloperUtil.getDockingWindowLayout(dockingWindow, 0);
    }

    public static JFrame createWindowLayoutFrame(String string, final DockingWindow dockingWindow) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        final JTextArea jTextArea = new JTextArea(DeveloperUtil.getWindowLayoutAsString(dockingWindow));
        JButton jButton = new JButton("Get Current Layout");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.setText(DeveloperUtil.getWindowLayoutAsString(dockingWindow));
            }
        });
        Box box = new Box(0);
        box.add(jButton);
        jFrame.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        jFrame.getContentPane().add((Component)box, "North");
        jFrame.pack();
        return jFrame;
    }

    private static String getDockingWindowLayout(DockingWindow dockingWindow, int n) {
        if (dockingWindow instanceof RootWindow) {
            return DeveloperUtil.getRootWindowLayout((RootWindow)dockingWindow, n);
        }
        String string = n > 0 ? "\n" : "";
        for (int i = 0; i < n; ++i) {
            string = string + INDENT_STRING;
        }
        string = dockingWindow instanceof TabWindow ? string + DeveloperUtil.getTabWindowLayout((TabWindow)dockingWindow, n + 1) : (dockingWindow instanceof SplitWindow ? string + DeveloperUtil.getSplitWindowLayout((SplitWindow)dockingWindow, n + 1) : string + DeveloperUtil.getViewLayout((View)dockingWindow, n + 1));
        return string;
    }

    private static String getRootWindowLayout(RootWindow rootWindow, int n) {
        String string = "";
        if (rootWindow.getWindow() != null) {
            string = string + "<rootWindow>.setWindow(" + DeveloperUtil.getDockingWindowLayout(rootWindow.getWindow(), n) + ");\n\n";
        }
        for (int i = 0; i < rootWindow.getChildWindowCount(); ++i) {
            DockingWindow dockingWindow;
            DockingWindow dockingWindow2 = rootWindow.getChildWindow(i);
            if (dockingWindow2 == rootWindow.getWindow()) continue;
            if (dockingWindow2 instanceof WindowBar) {
                dockingWindow = (WindowBar)dockingWindow2;
                if (((AbstractTabWindow)dockingWindow).getChildWindowCount() <= 0) continue;
                for (int j = 0; j < ((AbstractTabWindow)dockingWindow).getChildWindowCount(); ++j) {
                    string = string + "<rootWindow>.getWindowBar(Direction." + ((WindowBar)dockingWindow).getDirection().toString().toUpperCase() + ").addTab(" + DeveloperUtil.getDockingWindowLayout(((AbstractTabWindow)dockingWindow).getChildWindow(j), n) + ");\n";
                }
                string = string + "\n";
                continue;
            }
            if (!(dockingWindow2 instanceof FloatingWindow)) continue;
            dockingWindow = (FloatingWindow)dockingWindow2;
            Point point = dockingWindow.getTopLevelAncestor().getLocation();
            Dimension dimension = dockingWindow.getRootPane().getSize();
            string = string + "<rootWindow>.createFloatingWindow(new Point(" + point.x + ", " + point.y + "), new Dimension(" + dimension.width + ", " + dimension.height + "), ";
            string = string + DeveloperUtil.getDockingWindowLayout(((FloatingWindow)dockingWindow).getChildWindow(0), n);
            string = string + ");\n\n";
        }
        return string;
    }

    private static String getTabWindowLayout(TabWindow tabWindow, int n) {
        if (tabWindow.getChildWindowCount() == 1 && tabWindow.getChildWindow(0) instanceof View) {
            return DeveloperUtil.getViewLayout((View)tabWindow.getChildWindow(0), n);
        }
        String string = "new TabWindow(new DockingWindow[]{";
        for (int i = 0; i < tabWindow.getChildWindowCount(); ++i) {
            string = string + DeveloperUtil.getDockingWindowLayout(tabWindow.getChildWindow(i), n);
            if (i >= tabWindow.getChildWindowCount() - 1) continue;
            string = string + ", ";
        }
        string = string + "})";
        return string;
    }

    private static String getSplitWindowLayout(SplitWindow splitWindow, int n) {
        String string = "new SplitWindow(" + splitWindow.isHorizontal() + ", " + splitWindow.getDividerLocation() + "f, ";
        string = string + DeveloperUtil.getDockingWindowLayout(splitWindow.getLeftWindow(), n) + ", ";
        string = string + DeveloperUtil.getDockingWindowLayout(splitWindow.getRightWindow(), n);
        string = string + ")";
        return string;
    }

    private static String getViewLayout(View view, int n) {
        return "View: \"" + view.getTitle() + "\" - " + view.getClass();
    }
}

