/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.border;

import java.awt.Component;
import java.awt.Insets;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.shaped.border.PolygonBorder;

public class RoundedCornerBorder
extends PolygonBorder {
    private static final long serialVersionUID = 1L;
    private static int[][] corner1 = new int[][]{{0, 0}, {0, 1, 1, 0}, {0, 2, 2, 0}, {0, 4, 1, 3, 1, 2, 2, 1, 3, 1, 4, 0}, {0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0}};
    private static int[][] corner2 = new int[][]{{-1, 0}, {-2, 0, -1, 1}, {-3, 0, -1, 2}, {-5, 0, -4, 1, -3, 1, -2, 2, -2, 3, -1, 4}, {-6, 0, -5, 1, -4, 1, -2, 3, -2, 4, -1, 5}};
    private static int[][] corner3 = new int[][]{{-1, -1}, {-1, -2, -2, -1}, {-1, -3, -3, -1}, {-1, -5, -2, -4, -2, -3, -3, -2, -4, -2, -5, -1}, {-1, -6, -2, -5, -2, -4, -4, -2, -5, -2, -6, -1}};
    private static int[][] corner4 = new int[][]{{0, -1}, {1, -1, 0, -2}, {2, -1, 0, -3}, {4, -1, 3, -2, 2, -2, 1, -3, 1, -4, 0, -5}, {5, -1, 4, -2, 3, -2, 1, -4, 1, -5, 0, -6}};
    private Insets insets;

    public RoundedCornerBorder(ColorProvider colorProvider, int n) {
        this(colorProvider, n, true, true, true, true);
    }

    public RoundedCornerBorder(ColorProvider colorProvider, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(colorProvider, FixedColorProvider.WHITE, n, n, n, n, bl, bl2, bl3, bl4);
    }

    public RoundedCornerBorder(ColorProvider colorProvider, ColorProvider colorProvider2, int n, int n2, int n3, int n4) {
        this(colorProvider, colorProvider2, n, n2, n3, n4, true, true, true, true);
    }

    public RoundedCornerBorder(ColorProvider colorProvider, ColorProvider colorProvider2, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(colorProvider, colorProvider2, RoundedCornerBorder.createCoordinates(n, n2, n3, n4, bl, bl2, bl3, bl4), RoundedCornerBorder.createXScales(n, n2, n3, n4), RoundedCornerBorder.createYScales(n, n2, n3, n4));
        this.insets = new Insets(bl ? 1 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0);
    }

    protected Insets getShapedBorderInsets(Component component) {
        return this.insets;
    }

    private static int[] createCoordinates(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n5;
        int[] nArray = corner1[n];
        int[] nArray2 = corner2[n2];
        int[] nArray3 = corner3[n3];
        int[] nArray4 = corner4[n4];
        int[] nArray5 = new int[nArray.length + nArray2.length + nArray3.length + nArray4.length];
        int n6 = 0;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nArray5[n6] = bl2 ? nArray[n5] : nArray[n5] - 1;
            nArray5[++n6] = bl ? nArray[n5] : nArray[++n5] - 1;
            ++n6;
        }
        for (n5 = 0; n5 < nArray2.length; ++n5) {
            nArray5[n6] = bl4 ? nArray2[n5] : nArray2[n5] + 1;
            nArray5[++n6] = bl ? nArray2[n5] : nArray2[++n5] - 1;
            ++n6;
        }
        for (n5 = 0; n5 < nArray3.length; ++n5) {
            nArray5[n6] = bl4 ? nArray3[n5] : nArray3[n5] + 1;
            nArray5[++n6] = bl3 ? nArray3[n5] : nArray3[++n5] + 1;
            ++n6;
        }
        for (n5 = 0; n5 < nArray4.length; ++n5) {
            nArray5[n6] = bl2 ? nArray4[n5] : nArray4[n5] - 1;
            nArray5[++n6] = bl3 ? nArray4[n5] : nArray4[++n5] + 1;
            ++n6;
        }
        return nArray5;
    }

    private static float[] createXScales(int n, int n2, int n3, int n4) {
        int[][] nArray = new int[4][1];
        nArray[0] = corner1[n];
        nArray[1] = corner2[n2];
        nArray[2] = corner3[n3];
        nArray[3] = corner4[n4];
        float[] fArray = new float[nArray[0].length + nArray[1].length + nArray[2].length + nArray[3].length];
        int n5 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                fArray[n5] = nArray[i][j] < 0 ? 1.0f : 0.0f;
                ++j;
                n5 += 2;
            }
        }
        return fArray;
    }

    private static float[] createYScales(int n, int n2, int n3, int n4) {
        int[][] nArray = new int[4][1];
        nArray[0] = corner1[n];
        nArray[1] = corner2[n2];
        nArray[2] = corner3[n3];
        nArray[3] = corner4[n4];
        float[] fArray = new float[nArray[0].length + nArray[1].length + nArray[2].length + nArray[3].length];
        int n5 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 1; j < nArray[i].length; ++j) {
                fArray[n5] = nArray[i][j] < 0 ? 1.0f : 0.0f;
                ++j;
                n5 += 2;
            }
        }
        return fArray;
    }
}

