/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;

public class DelayedHoverExitAction
implements HoverListener {
    private HashMap timers = new HashMap();
    private HashMap exitEvents = new HashMap();
    private HoverListener action;
    private int delay;

    public DelayedHoverExitAction(HoverListener hoverListener, int n) {
        this.action = hoverListener;
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public HoverListener getHoverAction() {
        return this.action;
    }

    public void forceExit(Component component) {
        if (this.timers.containsKey(component)) {
            ((Timer)this.timers.get(component)).stop();
            this.timers.remove(component);
            HoverEvent hoverEvent = (HoverEvent)this.exitEvents.get(component);
            this.exitEvents.remove(component);
            this.action.mouseExited(hoverEvent);
        }
    }

    public void mouseEntered(HoverEvent hoverEvent) {
        final Component component = hoverEvent.getSource();
        if (this.timers.containsKey(component)) {
            ((Timer)this.timers.get(component)).stop();
        } else {
            Timer timer = new Timer(this.delay, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DelayedHoverExitAction.this.forceExit(component);
                }
            });
            timer.setRepeats(false);
            this.timers.put(component, timer);
            this.action.mouseEntered(hoverEvent);
        }
    }

    public void mouseExited(HoverEvent hoverEvent) {
        this.exitEvents.put(hoverEvent.getSource(), hoverEvent);
        ((Timer)this.timers.get(hoverEvent.getSource())).restart();
    }
}

