/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.internal.FocusTraversalUtilsAccessor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public final class Forms {
    private Forms() {
    }

    public static JComponent single(String columnSpec, String rowSpec, JComponent component) {
        Preconditions.checkNotBlank((String)columnSpec, (String)"The %1$s must not be null, empty, or whitespace.", (Object[])new Object[]{"column specification"});
        Preconditions.checkNotBlank((String)rowSpec, (String)"The %1$s must not be null, empty, or whitespace.", (Object[])new Object[]{"row specification"});
        Preconditions.checkNotNull((Object)component, (String)"The %1$s must not be null.", (Object[])new Object[]{"component"});
        FormLayout layout = new FormLayout(columnSpec, rowSpec);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.add((Component)component, CC.xy(1, 1));
        return builder.build();
    }

    public static JComponent centered(JComponent component) {
        return Forms.single("center:pref:grow", "c:p:g", component);
    }

    public static JComponent border(Border border, JComponent component) {
        JComponent container = Forms.single("fill:pref", "f:p", component);
        container.setBorder(border);
        return container;
    }

    public static JComponent border(String emptyBorderSpec, JComponent component) {
        return Forms.border(Borders.createEmptyBorder(emptyBorderSpec), component);
    }

    public static JComponent horizontal(String gapColSpec, JComponent ... components) {
        Preconditions.checkNotBlank((String)gapColSpec, (String)"The %1$s must not be null, empty, or whitespace.", (Object[])new Object[]{"gap column specification"});
        Preconditions.checkNotNull((Object)components, (String)"The %1$s must not be null.", (Object[])new Object[]{"component array"});
        Preconditions.checkArgument((components.length > 1 ? 1 : 0) != 0, (String)"You must provide more than one component.");
        FormLayout layout = new FormLayout(components.length - 1 + "*(pref, " + gapColSpec + "), pref", "p");
        PanelBuilder builder = new PanelBuilder(layout);
        int column = 1;
        for (JComponent component : components) {
            builder.add((Component)component, CC.xy(column, 1));
            column += 2;
        }
        return builder.build();
    }

    public static JComponent vertical(String gapRowSpec, JComponent ... components) {
        Preconditions.checkNotBlank((String)gapRowSpec, (String)"The %1$s must not be null, empty, or whitespace.", (Object[])new Object[]{"gap row specification"});
        Preconditions.checkNotNull((Object)components, (String)"The %1$s must not be null.", (Object[])new Object[]{"component array"});
        Preconditions.checkArgument((components.length > 1 ? 1 : 0) != 0, (String)"You must provide more than one component.");
        FormLayout layout = new FormLayout("pref", components.length - 1 + "*(p, " + gapRowSpec + "), p");
        PanelBuilder builder = new PanelBuilder(layout);
        int row = 1;
        for (JComponent component : components) {
            builder.add((Component)component, CC.xy(1, row));
            row += 2;
        }
        return builder.build();
    }

    public static JComponent buttonBar(JComponent ... buttons) {
        return new ButtonBarBuilder().addButton(buttons).build();
    }

    public static JComponent checkBoxBar(JCheckBox ... checkBoxes) {
        return Forms.buildGroupedButtonBar(checkBoxes);
    }

    public static JComponent radioButtonBar(JRadioButton ... radioButtons) {
        return Forms.buildGroupedButtonBar(radioButtons);
    }

    protected static JComponent buildGroupedButtonBar(AbstractButton ... buttons) {
        Preconditions.checkArgument((buttons.length > 1 ? 1 : 0) != 0, (String)"You must provide more than one button.");
        FormLayout layout = new FormLayout(buttons.length - 1 + "*(pref, $rgap), pref", "p");
        PanelBuilder builder = new PanelBuilder(layout);
        int column = 1;
        for (AbstractButton button : buttons) {
            builder.add((Component)button, CC.xy(column, 1));
            column += 2;
        }
        FocusTraversalUtilsAccessor.tryToBuildAFocusGroup(buttons);
        return builder.build();
    }
}

