\name{CompoundEvents-package}
\docType{package}
\title{Statistical Modeling of Compound Events}
\description{
Tools for extracting occurrences, assessing potential driving factors, predicting occurrences,
and quantifying impacts of compound events in hydrology and climatology.
}

\details{
Examples of compound events in hydroclimatology include, but not limited to, compound dry-hot events and compound precipitation and surge (or sea level) events. Take the compound dry and hot event as an example. The function \code{\link{GetDH}} is used for extracting occurrences based on thresholds of dry and hot indicators. The function \code{\link{DriverLGR}} is used for assessing potential driving factors of compound events based on logistic regression model. The function \code{\link{PredLGR}} is used for predicting occurrences of compound events. The function \code{\link{ImpactMG}} is used for quantifying impacts of compound dry and hot events based on meta-Gaussian model.
}
\author{
Zengchao Hao
}
\references{


Hao, Z., et al.( 2013). Changes in concurrent monthly precipitation and temperature extremes. Environ. Res. Lett. 8: 034014.


Hao, Z. et al. (2019). A monitoring and prediction system for compound dry and hot events. Environ. Res. Lett., 14:114034.


Hao, Z. et al. (2019). Statistical prediction of the severity of compound dry-hot events based on ENSO . J. Hydrol., 572: 243-250.

Feng, S. et al. (2019). Probabilistic evaluation of the impact of compound dry-hot events on global maize yields. Sci. Total. Environ., 689: 1228-1234.
}

