% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAH.R
\name{calcAH}
\alias{calcAH}
\title{Calculate Absolute Humidity}
\usage{
calcAH(Temp, RH, P_atm = 1013.25)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{P_atm}{Atmospheric pressure = 1013.25 (hPa)}
}
\value{
AH Absolute Humidity (g/m³)
}
\description{
Function to calculate the absolute humidity (g/m³) from temperature (°C) and relative humidity (\%).

Absolute humidity is the mass of water in a unit volume of air at a given temperature and pressure.
}
\examples{
calcAH(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(Abs = calcAH(Temp, RH))


}
\references{
Buck, A. L. (1981). New equations for computing vapor pressure and enhancement factor. Journal of Applied Meteorology, 20(12), 1527-1532.
}
