% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankReg.R
\name{RankReg}
\alias{RankReg}
\title{Rank the regression models based on the confidence envelope for minimum ZIC}
\usage{
RankReg(data,alphaval, model_ZIC=c("AIC","BIC","AICc"))
}
\arguments{
\item{data}{a matrix of \eqn{n} by \eqn{(m+1)} where \eqn{m} is the number of independent variables. First column should be the dependent variable and the rest of the \eqn{m} columns should be the independent variables of the dataset. Maximum of \eqn{m} should be 10.}

\item{alphaval}{confidence limit of the confidence envelope.}

\item{model_ZIC}{type of the information criterion, it can be "AIC", "BIC", or "AICc" (Default is the "AIC").}
}
\value{
A list containing at least the following components.

\item{Ranked_Models}{A set of top ranked models which lie in the confidence envelop \eqn{CE(\alpha)} (with variables list and the ranked ZIC values ("AIC", "BIC", or "AICc")) for regression data.
\eqn{0} represents the coefficient while \eqn{1,2,...,m} give the corresponding columns of independent variables \eqn{X_1,X_2,...,X_m} respectively.}

\item{Confidence_Envelope}{gives the confidence envelope \eqn{CE(\alpha)} for the minimum ZIC.}

\item{Confidence_Limit}{the confidence limit, \eqn{1-\alpha}.}

\item{Tota_Models}{number of total fitted models.}
}
\description{
Narrow down the number of models to look at in model selection using the confidence envelope based on the minimum ZIC values for regression data. Here, we compute the ZIC values ("AIC", "BIC", or "AICc") for regression data, confidence envelope for the minimum ZIC values for the given confidence limit, and rank the best models which lie in the confidence envelope.
}
\details{
This program involves the computation of multivariate normal-probabilities with covariance matrices based on minimum ZIC inverting the CDF of the minimum ZIC. It involves both the computation of singular and nonsingular probabilities. The methodology is described in Genz (1992).

Let \eqn{X_j} be the ZIC value for the \eqn{j^{th}} fitted model. Compute the cdf values of the minimum ZIC, \eqn{F_{X_{(1)}}(\cdot)} numerically and then obtain the \eqn{100\cdot (1-\alpha)\%} confidence envelope:
\deqn{CE(\alpha)=F^{-1}_{X_{(1)}}(1-\alpha)}

See details:

Jayaweera I.M.L.N, Trindade A.A., ``How Certain are You in Your Minimum AIC and BIC Values?", Sankhya A (2023+)
}
\examples{
\donttest{
library("ConfZIC")
data(Concrete)
x=Concrete
Y=x[,9] #dependent variable
#independent variables
X1=x[,1];X2=x[,2];X3=x[,3];X4=x[,4];
X5=x[,5];X6=x[,6];X7=x[,7];X8=x[,8];
mydata=cbind(Y,X1,X2,X3,X4,X5,X6,X7,X8) #data matrix
RankReg(mydata,0.95,"BIC")
}
}
\references{
Genz, A. (1992). Numerical computation of multivariate normal probabilities. Journal of computational and graphical statistics, 1(2), 141-149.
}
