% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectednessTable.R
\name{ConnectednessTable}
\alias{ConnectednessTable}
\title{Connectedness table}
\usage{
ConnectednessTable(FEVD, digit = 2)
}
\arguments{
\item{FEVD}{Forecast error variance decomposition}

\item{digit}{Number of decimal places}
}
\value{
Get connectedness table
}
\description{
This function provides standard connectedness table.
}
\examples{
\donttest{
data("dy2012")
fit = VAR(dy2012, configuration=list(nlag=1))
fevd = FEVD(Phi=fit$B, Sigma=fit$Q, nfore=10, type="time", generalized=TRUE)$FEVD
dca = ConnectednessTable(fevd)
}
}
