/*
 * Decompiled with CFR 0.152.
 */
package hughes;

import hughes.ArrayContainer;
import hughes.Iterator;

public abstract class Heap
extends ArrayContainer {
    protected Comparable[] data;

    public Heap() {
        ((ArrayContainer)this).data = null;
        this.data = new Comparable[1000];
    }

    public Heap(int initCapacity) {
        ((ArrayContainer)this).data = null;
        this.data = initCapacity <= 0 ? new Comparable[1000] : new Comparable[initCapacity];
    }

    public int capacity() {
        return this.data.length;
    }

    public void clear() {
        for (int j = 0; j < this.numItems; ++j) {
            this.data[j] = null;
        }
        this.numItems = 0;
    }

    public void contract() {
        if (this.size() == this.data.length) {
            return;
        }
        Comparable[] newData = new Comparable[this.size()];
        for (int j = 0; j < this.size(); ++j) {
            newData[j] = this.data[j];
        }
        this.data = newData;
    }

    public Iterator iterator() {
        return new HeapIterator(this);
    }

    protected abstract void percolate();

    public void insert(Comparable element) {
        if (this.isFull()) {
            Comparable[] newData = new Comparable[this.data.length * 2];
            for (int j = 0; j < this.numItems; ++j) {
                newData[j] = this.data[j];
            }
            this.data = newData;
        }
        this.data[this.numItems++] = element;
        this.percolate();
    }

    protected boolean isLeaf(int pos) {
        return 2 * pos + 1 >= this.size();
    }

    protected int leftChild(int pos) {
        if (pos < 0) {
            return -1;
        }
        return 2 * pos + 1;
    }

    protected int rightChild(int pos) {
        if (pos < 0) {
            return -1;
        }
        return 2 * pos + 2;
    }

    protected int parent(int pos) {
        if (pos < 1) {
            return -1;
        }
        return (pos - 1) / 2;
    }

    protected Comparable peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.data[0];
    }

    protected abstract void sift();

    protected Comparable remove() {
        if (this.isEmpty()) {
            return null;
        }
        this.swap(this.data, 0, this.size() - 1);
        Comparable root = this.data[this.size() - 1];
        this.data[--this.numItems] = null;
        if (this.size() != 0) {
            this.sift();
        }
        return root;
    }

    protected void swap(Comparable[] arr, int first, int second) {
        Comparable temp = arr[first];
        arr[first] = arr[second];
        arr[second] = temp;
    }

    protected static class HeapIterator
    implements Iterator {
        protected Heap h;
        protected int current = -1;

        public HeapIterator(Heap aHeap) {
            this.h = aHeap;
        }

        public void start() {
            if (!this.h.isEmpty()) {
                this.current = 0;
            }
        }

        public void rstart() {
        }

        public boolean isItem() {
            return this.current != -1;
        }

        public Object current() {
            if (this.isItem()) {
                return this.h.data[this.current];
            }
            return null;
        }

        public void moveForward() {
            if (this.isItem()) {
                ++this.current;
            }
            if (this.current == this.h.size()) {
                this.current = -1;
            }
        }

        public void moveBackward() {
        }

        public boolean insert(Object newItem) {
            return false;
        }

        public boolean attach(Object newItem) {
            return false;
        }

        public boolean remove() {
            return false;
        }
    }
}

