% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApexGame.R
\name{apexGameVector}
\alias{apexGameVector}
\title{Compute game vector for an apex game}
\usage{
apexGameVector(n, apexPlayer)
}
\arguments{
\item{n}{represents the number of players}

\item{apexPlayer}{specifies the number of the apex player}
}
\value{
Game vector for the apex game
}
\description{
\strong{Game vector for an apex game:} \cr
For further information see \link{apexGame}
}
\examples{
library(CoopGame)
apexGameVector(n=3,apexPlayer=2)

\donttest{
library(CoopGame)
(v <- apexGameVector(n=4,apexPlayer=3))
#[1] 0 0 0 0 0 1 0 1 0 1 1 1 1 1 1
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 164--165
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
