% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot}
\alias{plot}
\alias{plot,cdtafit-method}
\title{A function to produce forest plots.}
\usage{
plot(object, ...)

\S4method{plot}{cdtafit}(
  object,
  title.1 = NULL,
  title.2 = NULL,
  title.3 = NULL,
  graph = NULL,
  width = 0.2,
  shape.1 = 19,
  size.1 = 2.5,
  shape.2 = 8,
  size.2 = 2.5,
  shape.O = 9,
  size.O = 3.5,
  cols.1 = NULL,
  cols.2 = NULL,
  digits = 3,
  ...
)
}
\arguments{
\item{object}{A cdtafit object from \link{fit}.}

\item{...}{other \link[rstan]{stan} options.}

\item{title.1}{An optional string indicating the title of graph 1.}

\item{title.2}{An optional string indicating the title of graph 2.}

\item{title.3}{An optional string indicating the title of graph 3.}

\item{graph}{An optional numeric value indicating which forest to plot(s) to graph. Valid values are:0 - for no graph, 1 - yielding a forest plot of the
sensitivity and specificity with a 95 percent exact confidence intervals, 2 - yielding a forest plot of the posterior study-specific sensitivity and specificity
and the marginal mean sensitivity and specificity and their corresponding 95 percent credible intervals, 3 - yielding a combination of 1 and 2 in one plot, and NULL(default) - yielding plots of
1, 2 and 3.}

\item{width}{An optional numeric value to adjust the dogding position. The default is 0.2.}

\item{shape.1}{An optional numeric value(0-255) indicating the symbol to plot in graph 1. The default is 19 which is a solid circle. See \link[graphics]{points} for more details.}

\item{size.1}{An optional positive numeric value indicating the size of symbols in graph 1. The default is 2.5.}

\item{shape.2}{An optional numeric value(0-255) indicating the symbol to plot in graph 2. The default is 8 which is a star. See \link[graphics]{points} for more details.}

\item{size.2}{An optional positive numeric value indicating the size of symbols in graph 2. The default is 2.5.}

\item{shape.O}{An optional numeric value(0-255) indicating the symbol representing the posterior marginal mean in graph 2. The default is 19 which is a solid circle. See \link[graphics]{points} for more details.}

\item{size.O}{An optional numeric value indicating the size of symbols representing the posterior marginal means in graph 2.}

\item{cols.1}{An optional string vector specifying colours of shapes in graph 1.}

\item{cols.2}{An optional string vector specifying colours of shapes in graph 2.}

\item{digits}{An optional positive value to control the number of digits to print when printing numeric values. The default is 3.}
}
\description{
A function to produce forest plots.
}
