% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64decode.R
\name{base64decode}
\alias{base64decode}
\alias{base64encode}
\title{base64decode.}
\usage{
base64decode(z, what, size = NA, signed = TRUE, endian = .Platform$endian)

base64encode(x, size = NA, endian = .Platform$endian)
}
\arguments{
\item{z}{The base64 encoded string.}

\item{what}{Define output type of z (e.g. 'numeric').}

\item{size}{Encoding size (provide if you know it).}

\item{signed}{Parameter passed through to `readBin`.}

\item{endian}{Parameter passed through to `readBin`.}

\item{x}{The value vector to be encoded.}
}
\value{
Decoded value of z.#'
}
\description{
`base64decode` is a copy of a similar function from the caTools 
    package as this package is about to be archived (07/2018).
}
\details{
`base64decode` will convert base64 encoded strings into R values.#'
}
\examples{
\dontrun{
# you need to have the bitops package installed to run the example
x <- c(10, 0.2, 123456)
(z <- base64encode(x = x))
base64decode(z = z, what = "numeric")
(x <- as.integer(x))
(z <- base64encode(x = x))
base64decode(z = z, what = "int")
}
}
