% Generated by roxygen2 (4.0.1): do not edit by hand
\name{computeDiagPhotoZ}
\alias{computeDiagPhotoZ}
\title{Simple diagnostics for the photometric redshift results}
\usage{
computeDiagPhotoZ(photoz, specz)
}
\arguments{
\item{photoz}{vector}

\item{specz}{vector}
}
\value{
a list containing the summary statistics
}
\description{
\code{computeDiagPhotoZ} computes a list of simple summary
statistics for the photometric redshift estimation.
}
\examples{
# First, generate some mock data
ppo <- runif(1000, min=0.1, max=2)
ppo_ph <- rnorm(length(ppo), mean=ppo, sd=0.05)

# Now, compute the summary stats
computeDiagPhotoZ(ppo_ph, ppo)
}
\author{
Rafael S. de Souza, Alberto Krone-Martins
}
\keyword{misc}

