% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--analysis_tools--time_offset--Offset_Analysis.R
\name{OffsetDFMaker}
\alias{OffsetDFMaker}
\title{Returns a dataframe with the multiple ways to analyze how offset the Wastewater is from cases data}
\usage{
OffsetDFMaker(
  length,
  startdate,
  enddate,
  casesdf,
  wastedf,
  N1_column = N1,
  N2_column = N2,
  site_column = site,
  date_column = date,
  case_column = conf_case
)
}
\arguments{
\item{length}{The length of the time window for the results / 2}

\item{startdate}{First day for both data sets}

\item{enddate}{Last day for both data sets}

\item{casesdf}{DF with case data columns needed(data,conf_case)}

\item{wastedf}{DF with Wastewater data columns needed(date,N1,N2)}

\item{N1_column}{name of N1 column}

\item{N2_column}{name of N2 column}

\item{site_column}{name of site column}

\item{date_column}{name of date column}

\item{case_column}{name of case column}
}
\value{
DF with the columns: number of days wastewater is offset, geo mean of(n1,n2) / confirmed cases,previous with rolling case average, MSE rolling average,Pearson correlation, Kendall correlation, Spearman correlation, R squared.
}
\description{
Returns a dataframe with the multiple ways to analyze how offset the Wastewater is from cases data
}
\examples{
data(WasteWater_data, package = "Covid19Wastewater")
data("Case_data", package = "Covid19Wastewater")
#Will output a df from -10 to +10 days using all of the data from 2020-08-01 to 2023-01-01
OffsetDFMaker(10,as.Date("2020-08-01"), as.Date("2023-01-01"), Case_data, WasteWater_data) 
}
