% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--analysis_tools--DHS_methods--classification_function.R
\name{classifyCaseRegression}
\alias{classifyCaseRegression}
\title{Create Case Flags based on regression slope}
\usage{
classifyCaseRegression(
  DF,
  slopeThreshold = 5,
  minSize = 200,
  per_changed_column = modeled_percentchange,
  model_sig_column = lmreg_sig
)
}
\arguments{
\item{DF}{dataframe that contains results of buildRegressionEstimateTable}

\item{slopeThreshold}{number threshold for case_flag flagging}

\item{minSize}{case threshold for case_flag_plus_comm.threshold flagging}

\item{per_changed_column}{column name of estimated percent change of signal}

\item{model_sig_column}{column name of significance of linear model that generated 
the percent change}
}
\value{
DF with an three extra column Category containing the case flags
case_flag: when the 7 day slope is above slopeThreshold
case_flag_plus_comm.threshold: when case flag and more then 200 cases
slope_switch_flag: the first case flags in consecutive case flags
}
\description{
Create Case Flags based on regression slope
}
\examples{
example_DF <- data.frame(site = "madison", lmreg_slope = 5, value = 300)
classifyCaseRegression(example_DF)
}
