% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--analysis_tools--lm_rand_forest--class_methods.R
\name{random_linear_forest}
\alias{random_linear_forest}
\title{Fitting linear random forest}
\usage{
random_linear_forest(
  data,
  num_tree,
  model_formula,
  num_features = NULL,
  na.action = na.roughfix,
  max_depth = 5,
  importance = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{a dataframe containing the variables in the model}

\item{num_tree}{numeric, the number of trees in the random forest.}

\item{model_formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{num_features}{number of tree features in each tree. if left NULL rounded up square of the number of columns}

\item{na.action}{passed to lmtree to handle missing data}

\item{max_depth}{the max depth of each tree in the forest}

\item{importance}{controls if the importance should be calculated and stored}

\item{verbose}{If true it prints training progress}
}
\value{
random_linear_forest object trained using given data
}
\description{
This uses the linear tree model from party kit and bootstrapping
to create linear random forests that work like a random forest but with
the linear dynamics permuted with a linear method
}
\examples{
data(Example_data, package = "Covid19Wastewater")
random_linear_forest(Example_data, 2, PMMoV ~ N1 + N2 | pcr_type)
}
