% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphlb.ftest.plot.R
\name{coxphlb.ftest.plot}
\alias{coxphlb.ftest.plot}
\title{Graphical Test of the Functional Form of Covariates in Cox Model with Right-Censored Length-Biased Data}
\usage{
coxphlb.ftest.plot(x, n.plot = 20, seed.n = round(runif(1,1,1e09)))
}
\arguments{
\item{x}{The result of the \code{coxphlb.ftest} function.}

\item{n.plot}{The number of randomly selected realizations. Default is 20.}

\item{seed.n}{An integer specifying seed number.}
}
\description{
Returns a plot of the cumulative sums of mean zero stochastic processes.
}
\details{
The function returns a plot with the test statistics in a black line and 20 processes randomly sampled from the pool of resamples in grey lines. When the test statistics lie within the randomly sampled lines, it suggests that the model assumption is valid.
}
\examples{
\dontrun{
# Fit a Cox model
fit.ee <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = ExampleData1,
                 method = "EE")

# Check the Functional Form of the Cox Model
ftest <- coxphlb.ftest(fit.ee, data = ExampleData1, spec.p = 2,
                      seed.n = 1234)
coxphlb.ftest.plot(ftest, n.plot = 50, seed.n = 1234)			# display the plot
}
}
\references{
Lee, C.H., Ning, J., and Shen, Y. Model diagnostics for proportional hazards model with length-biased data. \emph{Lifetime Data Analysis} 25(1), 79-96.
}
\seealso{
\code{\link{coxphlb}}, \code{\link{coxphlb.ftest}}
}
