% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_lines.R
\name{crop_lines}
\alias{crop_lines}
\title{Find crop lines of an image}
\usage{
crop_lines(picture_list, final_ratio, best_image, intensity)
}
\arguments{
\item{picture_list}{One or more images created from rotating the same image.}

\item{final_ratio}{Any number, typically (0-1) that will be the ratio needed to determine a true crop row.}

\item{best_image}{The output of the best_rotations function.}

\item{intensity}{The amount of smoothing of the image.}
}
\value{
A vector of x-axis values for a given image.
}
\description{
Finds the crop row lines of an image. It uses other functions in the package such as: \code{\link{smoothing}}, \code{\link{localMaxima}}, and \code{\link{localMinima}}.
}
\details{
This function takes in: one or more images, a ratio that will become the threshold of what qualifies as a crop row, the index from \code{\link{best_rotation}} of what the best image was, and the intensity of smoothening from \code{\link{smoothing}}. It then uses the ratio as the threshold for acceptable crop rows and makes a list of the x-axis values.
}
\examples{
\donttest{crop_positions <- crop_lines(picture_list, 0.5, best_image, 0.25)}

}
