% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,CrossoverSearchResult,missing-method}
\title{Plots information about the search algorithm and its process.}
\usage{
\S4method{plot}{CrossoverSearchResult,missing}(x, y, type = 1,
  show.jumps = FALSE, ...)
}
\arguments{
\item{x}{Result from searchCrossOverDesign.}

\item{y}{Missing.}

\item{type}{Type of plot. Number 1 is
more colorful, but number 2 perhaps a bit easier to understand.}

\item{show.jumps}{If \code{TRUE} vertical lines will show where the specified
jumps occured.}

\item{...}{Arguments to be passed to methods, such as
    \link{graphical parameters} (see \code{\link{par}}).
    Many methods will accept the following arguments:
    \describe{
    \item{\code{type}}{what type of plot should be drawn.  Possible types are
      \itemize{
        \item \code{"p"} for \bold{p}oints,
        \item \code{"l"} for \bold{l}ines,
        \item \code{"b"} for \bold{b}oth,
        \item \code{"c"} for the lines part alone of \code{"b"},
        \item \code{"o"} for both \sQuote{\bold{o}verplotted},
        \item \code{"h"} for \sQuote{\bold{h}istogram} like (or
        \sQuote{high-density}) vertical lines,
        \item \code{"s"} for stair \bold{s}teps,
        \item \code{"S"} for other \bold{s}teps, see \sQuote{Details} below,
        \item \code{"n"} for no plotting.
      }
      All other \code{type}s give a warning or an error; using, e.g.,
      \code{type = "punkte"} being equivalent to \code{type = "p"} for S
      compatibility.  Note that some methods,
      e.g. \code{\link{plot.factor}}, do not accept this.
    }
    \item{\code{main}}{an overall title for the plot: see \code{\link{title}}.}
    \item{\code{sub}}{a sub title for the plot: see \code{\link{title}}.}
    \item{\code{xlab}}{a title for the x axis: see \code{\link{title}}.}
    \item{\code{ylab}}{a title for the y axis: see \code{\link{title}}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio,
      see \code{\link{plot.window}}.}
    }
  }
}
\value{
Returns a ggplot object of the plot.
}
\description{
Plots information about the search algorithm and its process.
}
\details{
The x-axis corresponds to the consecutive simulation runs and the y-axis to
the design criterion \var{E} that depending on the model is either a
weighted average of efficiency factors or standardized pairwise variances
and described in detail in the vignette of this package.  Also see the
vignette for a few examples and a discussion what can be derived from this
plots.
}
\examples{
x <- searchCrossOverDesign(s=9, p=5, v=4, model=4)
plot(x)

x <- searchCrossOverDesign(s=9, p=5, v=4, model=4, n=c(500,10), jumps=c(10, 100))
plot(x, show.jumps=TRUE)
plot(x, type=2)
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}

