% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multiplicative.LC.multi.R
\name{fit_multiplicative.LC.multi}
\alias{fit_multiplicative.LC.multi}
\title{FUNCTION TO FIT MULTIPLICATIVE MULTI-POPULATION MORTALITY MODEL}
\usage{
fit_multiplicative.LC.multi(qxt, periods, ages, nPop, lxt = NULL)
}
\arguments{
\item{qxt}{mortality rates used to fit the additive multipopulation mortality model. This rates can be provided in matrix or in data.frame.}

\item{periods}{periods considered in the fitting in a vector way c(minyear:maxyear).}

\item{ages}{vector with the ages considered in the fitting. If the mortality rates provide from an abridged life tables, it is required to provide a vector with the ages, see the example.}

\item{nPop}{number of population considered for fitting.}

\item{lxt}{survivor function considered for every population, not necessary to provide.}
}
\value{
A list with different components of the fitting process:
\itemize{
\item \code{ax} parameter that captures the average shape of the mortality curve in all considered populations.
\item \code{bx} parameter that explains the age effect x with respect to the general trend \code{kt} in the mortality rates of all considered populations.
\item \code{kt} represent the national tendency of multi-mortality populations during the period.
\item \code{Ii}  gives an idea of the differences in the pattern of mortality in any region i with respect to Region 1.
\item \code{formula}  additive multi-population mortality formula used to fit the mortality rates.
\item \code{data.used}  mortality rates used to fit the data.
\item \code{qxt.real}  real mortality rates.
\item \code{qxt.fitted}  fitted mortality rates using the additive  multi-population mortality model.
\item \code{logit.qxt.fitted}  fitted mortality rates in logit way.
\item \code{Ages}  provided ages to fit the data.
\item \code{Periods}  provided periods to fit the periods.
\item \code{nPop}  provided number of populations to fit the periods.
}
}
\description{
R function for fitting multiplicative multi-population mortality model developed by: Russolillo et al. (2011).
This model follows the structure of the well-known Lee-Carter model (Lee and Carter, 1992) but including a multiplicative parameter to capture the behavior of each population considered.
This parameter seeks to capture the individual behavior of every population considered.
It should be mentioned that in case that this function is developed for fitting several populations.
However, in case you only consider one population, the function will fit the one-population Lee-Carter model.
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest
\donttest{
#The data that we are going to use:
SpainRegions
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)
#In this case, we fit for males providing the lxt
library(gnm)
multiplicative_Spainmales <- fit_multiplicative.LC.multi(qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plotLC.multi(multiplicative_Spainmales)

#As we mentioned in the details of the function, if we only provide the data
#from one-population the function fit_multiplicative.LC.multi()
#will fit the Lee-Carter model for single populations.
LC_Spainmales <- fit_multiplicative.LC.multi(qxt = SpainNat$qx_male,
                              periods = c(1991:2020),
                              ages = ages,
                              nPop = 1)
plotLC.multi(LC_Spainmales)
}

}
\references{
Lee, R.D. & Carter, L.R. (1992).
Modeling and forecasting US mortality.
Journal of the American Statistical Association, 87(419), 659–671.

Russolillo, M., Giordano, G., & Haberman, S. (2011).
Extending the Lee–Carter model: a three-way decomposition.
Scandinavian Actuarial Journal, 2011(2), 96-117.
}
\seealso{
\code{\link{fit_additive.LC.multi}}, \code{\link{for_additive.LC.multi}},
\code{\link{for_multiplicative.LC.multi}}, \code{\link{multipopulation_cv}},
\code{\link{multipopulation_loocv}}
}
