% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_tags.R
\docType{methods}
\name{sample_tags}
\alias{sample_tags}
\alias{sample_tags.download}
\alias{sample_tags.download,UserSession-method}
\alias{sample_tags.upload}
\alias{sample_tags.upload,UserSession-method}
\title{Sample Tag Endpoints}
\usage{
\S4method{sample_tags.download}{UserSession}(UserSession, experiment_id,
  directory = getwd(), timeout = UserSession@short_timeout)

\S4method{sample_tags.upload}{UserSession}(UserSession, experiment_id,
  file_path, timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{timeout}{integer representing the request timeout time in seconds}

\item{file_path}{character representing a file path}
}
\description{
Interact with sample tag endpoints. (More descriptive text goes here)
}
\details{
\code{sample_tags.download} Download the sample tags from an experiment.

\code{sample_tags.upload} Upload sample tag annotation data TSV to an experiment.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{# Download the experiment sample tags TSV to the current working directory
sample_tags.download(cyto_session, 22)

# Download the experiment sample tags TSV to a new directory
sample_tags.download(cyto_session, 22, directory="/my/new/download/directory/")
}
\donttest{sample_tags.upload(cyto_session, 22, file_path="/path/to/my_annotations.tsv")
}
}

