% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CITRUS-class.R
\docType{class}
\name{CITRUS-class}
\alias{CITRUS-class}
\title{S4 CITRUS Class}
\value{
A CITRUS advanced analysis object
}
\description{
A CITRUS object that holds pertinent CITRUS advanced analysis run information, \href{https://support.cytobank.org/hc/en-us/articles/226940667-Overview-of-CITRUS}{learn more about CITRUS}.
This class should never be called explicitly. If a user would like to create a new Cytobank CITRUS object, utilize the \link{citrus.new} function, or any other \link[=citrus]{CITRUS endpoints that return CITRUS objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{associated_models}}{list representing statistical methods used to discover stratifying signatures from clustered data features that explain differences between sample groups, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Association_Models}{learn more about CITRUS association models}\cr
\emph{- choose from the following : \code{("sam", "pamr" [default], "glmnet")}}}

\item{\code{attachment_id}}{numeric representing the CITRUS attachment ID}

\item{\code{cross_validation_folds}}{numeric representing the regulation threshold, controlling the number of features in the model (only applies to PAM, LASSO), \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#cross_validation_fold}{learn more about CITRUS cross validation folds}}

\item{\code{citrus_id}}{numeric representing the CITRUS analysis ID}

\item{\code{cluster_characterization}}{character representing the principle for analyzing and quantifying individual samples, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Cluster_Characterization}{learn more about CITRUS cluster characterization}\cr
\emph{- choose one of the following : \code{("abundance" [default], "medians")}}}

\item{\code{event_sampling_method}}{character representing the sampling method, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Event_Sampling}{learn more about CITRUS event sampling methods}\cr
\emph{- choose one of the following : \code{("equal" [default], "max-per-file")}}}

\item{\code{events_per_file}}{numeric representing the number of events taken from each sample}

\item{\code{false_discovery_rate}}{numeric representing the false discovery rate (only applies to PAM, SAM), \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#False_Discovery_Rate_(FDR)}{learn more about CITRUS false discovery rate}}

\item{\code{file_grouping}}{numeric dataframe representing which group samples belong to, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Assigning_Sample_Groups}{learn more about CITRUS file grouping, the core functionality of CITRUS}}

\item{\code{minimum_cluster_size}}{numeric representing the number of nodes, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Minimum_Cluster_Size}{learn more about CITRUS minimum cluster size}}

\item{\code{normalize_scales}}{logical representing whether or not to normalize channels, \href{https://support.cytobank.org/hc/en-us/articles/226678087-How-to-Configure-and-Run-a-CITRUS-Analysis#Normalize_Scales}{learn more about normalizing CITRUS scales}}

\item{\code{plot_theme}}{character representing the background color of images and figures within the CITRUS results\cr
\emph{- choose one of the following : \code{("white" [default], "black")}}}

\item{\code{population_id}}{dataframe representing a population \strong{gate set ID}}

\item{\code{statistics_channels}}{list representing the statistics channels used for the 'median' cluster characterization, these channels should not be selected for clustering}
}}

