% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmarkers.R
\name{getmarkers}
\alias{getmarkers}
\title{Gets appropriate marker IDs for channels of interest}
\usage{
getmarkers(markersofinterest, exptno, cyto_session)
}
\arguments{
\item{markersofinterest}{- Names of channel parameters in Cytobank as list of strings}

\item{exptno}{- Integer representing an experiment ID on Cytobank account}

\item{cyto_session}{- API authentication token for session}
}
\value{
Returns a list of IDs for markers of interest with names of markers as names of list
}
\description{
Gets appropriate marker IDs for channels of interest
}
\examples{
\donttest{
library(CytobankAPI)
markersofinterest<-c("CD3","CD56")
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
exptno<-2
getmarkers(markersofinterest,exptno,cyto_session)}
}
