% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_fcs_files_stable.R, R/fcs_files.R
\name{fcs_files.download_fcs_files_stable}
\alias{fcs_files}
\alias{fcs_files.download_fcs_files_stable}
\title{FCS Files}
\usage{
fcs_files.download_fcs_files_stable(UserSession, experiment_id, fcs_files,
  directory = getwd(), zip_download = TRUE, timeout = 300)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{fcs_files}{vector/list of integers representing a list of FCS file IDs}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{zip_download}{logical representing whether or not to download each file one by one via ZIP download [default] or normal FCS download \strong{[optional]}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}
}
\description{
FCS File High Level Functions
}
\details{
\code{fcs_files.download_fcs_files_stable} Apply cluster gate(s) to specific clusters via an integer vector
}
\examples{
\donttest{fcs_files.download_fcs_files_stable(cyto_session, 22, fcs_files=c(1,2,3),
  directory="/my/new/download/directory/")
}
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
}

