% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{update_rates}
\alias{update_rates}
\title{Calculates algorithm rates}
\usage{
update_rates(
  timeval,
  total_time,
  gam,
  laa,
  lac,
  mu,
  hyper_pars = hyper_pars,
  area_pars = NULL,
  peak = NULL,
  island_ontogeny = NULL,
  sea_level = NULL,
  extcutoff,
  K,
  num_spec,
  num_immigrants,
  mainland_n,
  trait_pars = NULL,
  island_spec = NULL
)
}
\arguments{
\item{timeval}{Numeric defining current time of simulation.}

\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{gam}{A numeric with the per capita immigration rate.}

\item{laa}{A numeric with the per capita anagenesis rate.}

\item{lac}{A numeric with the per capita cladogenesis rate.}

\item{mu}{A numeric with the per capita extinction rate.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}

\item{peak}{A numeric value specifying the peakiness (or shaprness) of the
ontogeny curve. Higher values imply peakier ontogeny. This value is
internally calculated by \code{\link{calc_peak}()} given the area at the
present and the \code{area_pars}.}

\item{island_ontogeny}{In \code{\link{DAISIE_sim_time_dep}()},
\code{\link{DAISIE_ML_CS}} and plotting a string describing the type of
island ontogeny. Can be \code{"const"}, \code{"beta"} for a beta function
describing area through time. \cr In all other functions a
numeric describing the type of island ontogeny. Can be \code{0} for
constant, \code{1} for a beta function describing area through time. In ML
functions \code{island_ontogeny = NA} assumes constant ontogeny. Time
dependent estimation is not yet available as development is still ongoing.
Will return an error if called in that case.}

\item{sea_level}{In \code{\link{DAISIE_sim_time_dep}()} and plotting a
string describing the type of sea level. Can be \code{"const"} or
\code{"sine"} for a sine function describing area through time.
\cr In all other functions a numeric describing the type of sea level. Can
be \code{0} for constant, \code{1} for a sine function describing area
through time.}

\item{extcutoff}{A numeric with the cutoff for the the maximum extinction
rate preventing it from being too large and slowing down simulation.}

\item{K}{A numeric with carrying capacity.}

\item{num_spec}{A numeric with the current number of species.}

\item{num_immigrants}{A numeric with the current number of non-endemic
species (a.k.a non-endemic species).}

\item{mainland_n}{A numeric stating the number of mainland species, that
is the number of species that can potentially colonize the island.
If using a clade-specific diversity dependence, this value is set to 1.
If using an island-wide diversity dependence, this value is set to the
number of mainland species.}

\item{trait_pars}{A named list containing diversification rates considering
  two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state1}
  \item{[2]:A numeric with the per capita immigration rate with state2}
  \item{[3]:A numeric with the per capita extinction rate with state2}
  \item{[4]:A numeric with the per capita anagenesis rate with state2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state2}
  \item{[6]:A numeric with the per capita transition rate with state2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}

\item{island_spec}{Matrix with current state of simulation containing number
of species.}
}
\value{
a named list with the updated effective rates.
}
\description{
Internal function that updates the all the rates and
max extinction horizon at time t.
}
\seealso{
\code{\link{update_max_rates}()}

Other rate calculations: 
\code{\link{DAISIE_plot_area}()},
\code{\link{get_ana_rate}()},
\code{\link{get_ext_rate}()},
\code{\link{get_immig_rate}()},
\code{\link{island_area_vector}()},
\code{\link{island_area}()},
\code{\link{update_max_rates}()}
}
\concept{rate calculations}
\keyword{internal}
