% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_phylo_data.R
\name{check_phylo_data}
\alias{check_phylo_data}
\title{Checks whether `\linkS4class{phylo4d}` object conforms
to the requirements of the DAISIEprep package. If the function does not
return anything the data is ready to be used, if an error is returned the
data requires some pre-processing before DAISIEprep can be used}
\usage{
check_phylo_data(phylod)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}
}
\value{
Nothing or error message
}
\description{
Checks whether `\linkS4class{phylo4d}` object conforms
to the requirements of the DAISIEprep package. If the function does not
return anything the data is ready to be used, if an error is returned the
data requires some pre-processing before DAISIEprep can be used
}
\examples{
set.seed(
  1,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- sample(
  c("not_present", "endemic", "nonendemic"),
  size = length(phylobase::tipLabels(phylo)),
  replace = TRUE,
  prob = c(0.6, 0.2, 0.2)
)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
check_phylo_data(phylod)
}
