#' Dated phylogenetic tree of the New World Primates in nexus format and
#' presence-absence matrix for species in Manu
#' 
#' A list with two elements. \cr.  \code{phy} is a dated molecular phylogeny
#' for 94 species of New World Primates extracted from the maximum likelihood
#' tree (AUTOsoft dated) of Springer et al. (2012). 1 time unit = 100 million
#' years. \cr \code{pa} is the presence-absence matrix of NW Primates in Manu
#' from Solari et al. (2006). The first column indicate the species tip labels
#' and the second column indicates presence (1) and absence (0).
#' 
#' 
#' @name NWPrimates_data
#' @docType data
#' @format A list with two elements. The first element (\code{phy}) is the
#' primate phylogeny in nexus format. The second element (\code{pa}) is the
#' presence-absence matrix with 94 rows and 2 columns.
#' @seealso \code{\link{DAMOCLES_sim}}, \code{\link{DAMOCLES_ML}},
#' \code{\link{DAMOCLES_loglik}}
#' @source Solari, S., Pacheco, V., Luna, L., Velazco, P.M. & Patterson, B.D.
#' 2006 Mammals of the manu biosphere reserve. Fieldiana Zoology 110, 13-22.\cr
#' Springer, M.S., Meredith, R.W., Gatesy, J., Emerling, C.A., Park, J.,
#' Rabosky, D.L., Stadler, T., Steiner, C., Ryder, O.A., Janecka, J.E., et al.
#' 2012 Macroevolutionary dynamics and historical biogeography of primate
#' diversification inferred from a species supermatrix. Plos One 7. (doi:ARTN
#' e49521 DOI 10.1371/journal.pone.0049521).
#' @keywords datasets
NULL



