% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbGetQuery}
\alias{dbGetQuery}
\alias{dbGetQuery,DBIConnection,character-method}
\title{Send query, retrieve results and then clear result set.}
\usage{
dbGetQuery(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\description{
\code{dbGetQuery} comes with a default implementation that calls
\code{\link{dbSendQuery}}, then if \code{\link{dbHasCompleted}} is TRUE,
it uses \code{\link{fetch}} to return the results. \code{\link{on.exit}}
is used to ensure the result set is always freed by
\code{\link{dbClearResult}}.  Subclasses should override this method
only if they provide some sort of performance optimisation.
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
res <- dbSendQuery(con, "SELECT * FROM mtcars WHERE cyl = 4;")
dbFetch(res)
dbClearResult(res)

dbDisconnect(con)
}
}
\seealso{
Other connection methods: \code{\link{dbDisconnect}};
  \code{\link{dbExistsTable}};
  \code{\link{dbGetException}}; \code{\link{dbListFields}};
  \code{\link{dbListResults}}; \code{\link{dbListTables}};
  \code{\link{dbReadTable}}, \code{\link{dbWriteTable}};
  \code{\link{dbRemoveTable}}; \code{\link{dbSendQuery}}
}

