% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_xvt_results.R
\name{get_xvt_results}
\alias{get_xvt_results}
\title{Get results of DCPO cross-validation testing}
\usage{
get_xvt_results(dcpo_xvt_output, ci = 80)
}
\arguments{
\item{dcpo_xvt_output}{output from a single call to \code{DCPO::dcpo_xvt} or a k-fold test list of such output generated by purrr::map}

\item{ci}{an integer indicating the desired width of credible interval for coverage testing; 80 is the default.}
}
\value{
a stanfit object
}
\description{
\code{get_xvt_results} performs a single cross-validation test for dcpo's estimates of cross-national public opinion
}
\examples{
\donttest{
# Single cross-validation test with 25% test set
demsup_xvtest_25pct <- dcpo_xvt(demsup_data,
                           chime = FALSE,
                           number_of_folds = 4,
                           iter = 150,
                           chains = 2) # 2 chains/150 iterations for example only; use defaults

get_xvt_results(demsup_xvtest_25pct)

}
}
