% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic.ts.R
\name{henon.ts}
\alias{henon.ts}
\title{Simulation of time series from the Hénon map}
\usage{
henon.ts(a.min = 0.4, a.max = 1.4, b.min = 0.1, b.max = 0.3,
  sample = 1000, transient = 100, B = 100, doplot = TRUE)
}
\arguments{
\item{a.min}{a non-negative integer denoting a lower bound for the parameter \code{a} (Default 0.4).}

\item{a.max}{a non-negative integer denoting an upper bound for the parameter \code{a} (Default 1.4).}

\item{b.min}{a non-negative integer denoting a lower bound for the parameter \code{b} (Default 0.1).}

\item{b.max}{a non-negative integer denoting an upper bound for the parameter \code{b} (Default 0.3).}

\item{sample}{a non-negative integer denoting the length of each time serie (Default 1000).}

\item{transient}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values of each time serie are in the attractor (Default 100).}

\item{B}{a non-negative integer denoting the number of series that will be generated for different values of the parameters \code{a} and \code{b}. The number of simulated series must be at least 100 (Default 100).}

\item{doplot}{a logical value denoting if you want to draw a plot \code{TRUE} or not \code{FALSE}. If it is \code{TRUE} shows six graphs: the evolution of the temporal trajectories for the whole period, the attractor and its projections on the Cartesian plane and the bifurcation diagram. All of them consider both the 'x-coordinate' and the 'y-coordinate' (Default 'TRUE').}
}
\value{
A list containing as many items as series we want to simulate \code{B}. Each of them has the following attributes: the value of the parameter \code{a}, the value of the parameter \code{b}, the value of the initial condition \code{xo}, the value of the initial condition \code{yo} and a time serie from the iterated Hénon map with two columns corresponding to 'x-coordinate' and 'y-coordinate'.
}
\description{
This function simulates time series from the Hénon map considering the argument set selected by the user. The initial conditions of each time serie are two random numbers between -0.5 and 0.5. Some values for the parameters and initial conditions may lead to an unstable system that will tend to infinity.
}
\examples{
## Simulates 100 time series from the Hénon map for different
## values of the parameters a and b in which this system exhibits
## a chaotic behaviour:
ts<-henon.ts(a.min=0.7,a.max=1.4,b.min=0.1,b.max=0.3,B=100,doplot=TRUE)
}
\references{
Hénon, M. 1976 A two-dimensional mapping with a strange attractor. Communications in Mathematical Physics 50(1):69-77.
}
\seealso{
\code{\link{logistic.ts}}, \code{\link{rossler.ts}}, \code{\link{lorenz.ts}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
