% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{mseBS}
\alias{mseBS}
\title{Calculate Mean Squared Error( MSE) when Birnbaum-Saunders kernel is used}
\usage{
mseBS(y, k, h, type)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{type}{mention distribution of vector.If exponential distribution then use \code{"Exp"}.
if use gamma distribution then use \code{"Gamma"}.If Weibull distribution then use \code{"Weibull"}.}
}
\value{
MSE
}
\description{
Calculate MSE by using Birnbaum-Saunders Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
mseBS(y,200,h,"Exp")
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
}
\seealso{
For further MSE by using other kernels see \code{\link{mseLN}}, \code{\link{mseEr}} and \code{\link{mseGamma}}. For density estimation by using Birnbaum-Saunders Kernel \code{\link{plot.BS}} and to examine estimated values with grid points see \code{\link{BS}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
