% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{LogN}
\alias{LogN}
\title{Estimate Density Values by Lognormal kernel}
\usage{
LogN(x = NULL, y, k = NULL, h = NULL)
}
\arguments{
\item{x}{scheme for generating grid points}

\item{y}{a vector of positive values.}

\item{k}{grid points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
The \code{LogN} estimate Values of density by using Lognormal Kernel.The Lognomal kernel is developed by Jin and Kawczak (2003). For this too, they claimed that performance of their developed kernel is better near the
boundary points in terms of boundary reduction.
Lognormal Kernel is
\deqn{K_{LN(\ln(x),4\ln(1+h))}=\frac{1}{\sqrt{( 8\pi \ln(1+h))} y)} exp\left[-\frac{(\ln(y)-\ln(x))^2}{(8\ln(1+h))}\right]}
}
\details{
see the details in the \code{\link{BS}}.
}
\examples{
## Data: Simulated or real data can be used
## Number of grid points "k" should be at least equal to the data size.
## If user defines the generating scheme of grid points then length
## of grid points should be equal or greater than "k", Otherwise NA will be produced.
y <- rweibull(350, 1)
xx <- seq(0.001, max(y), length = 500)
h <- 2
den <- LogN(x = xx, y = y, k = 200, h = h)

##If scheme for generating grid points is unknown
n <- 1000
y <- abs(rlogis(n, location = 0, scale = 1))
h <- 3
LogN(y = y, k = 90, h = h)

\dontrun{
##If user do not mention the number of grid points
y <- rweibull(350, 1)
xx <- seq(0.00001, max(y), 500)

#any bandwidth can be used
require(ks)
h <- hscv(y)   #Smooth cross validation bandwidth
LogN(x = xx, y = y, h = h)
}

\dontrun{
#if both scheme and number of grid points are missing then function generate NA
n <- 1000
y <- abs(rlogis(n, location = 0, scale = 1))
band = 3
LogN(y = y, h = band)
}

#if bandwidth is missing
y <- rweibull(350, 1)
xx <- seq(0.001, 100, length = 500)
LogN(x = xx, y = y, k = 90)
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103-124.
}
\seealso{
For further kernels see \code{\link{Beta}}, \code{\link{BS}}, \code{\link{Erlang}} and \code{\link{Gamma}}. To plot its density see \code{\link{plot.LogN}} and to calculate MSE use \code{\link{mse}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
