% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.Gamma}
\alias{plot.Gamma}
\title{Density Plot by Gamma kernel}
\usage{
\method{plot}{Gamma}(x, ...)
}
\arguments{
\item{x}{an object of class "Gamma"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Gamma Kernel.
}
\examples{
y <- rexp(100, 1)
h <- 1.5
xx <- seq(min(y) + 0.05, max(y), length =200)
den <- Gamma(x=xx, y=y, k=200, h=h)
plot(den, type = "l")

##other details can also be added
y <- rexp(100, 2)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
gr <- Gamma(x=xx, y=y, k=200, h=h)
plot(gr, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")

## To add true density along with estimated
d1 <- density(y, bw=h)
lines(d1, type="p", col="red")
legend("topright", c("Real Density", "Density by Gamma Kernel"),
col=c("red", "black"), lty=c(1,2))

}
\references{
Chen, S. X. 2000. Probability density function estimation using Gamma kernels.  \emph{Annals of the Institute of Statistical Mathematics} \strong{52} (3), 471-480.
}
\seealso{
For further kernels see \code{\link{plot.Beta}},  \code{\link{plot.BS}}, \code{\link{plot.Erlang}} and \code{\link{plot.LogN}}. To calculate its estimated values see \code{\link{Gamma}} and for
MSE \code{\link{mse}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
